//
//  ChangeIndicatorView.swift
//  death_app Watch App
//
//  Created by Task Master on 2025-09-16.
//

import SwiftUI

struct ChangeIndicatorView: View {
    let dailyChange: Double
    let isPositive: Bool
    
    private var changeColor: Color {
        if abs(dailyChange) < 0.01 {
            return .secondary
        }
        return isPositive ? .green : .red
    }
    
    private var changeIcon: String {
        if abs(dailyChange) < 0.01 {
            return "minus"
        }
        return isPositive ? "arrow.up" : "arrow.down"
    }
    
    private var formattedChange: String {
        if abs(dailyChange) < 0.01 {
            return "No change"
        }
        return String(format: "%.1f days", abs(dailyChange))
    }
    
    var body: some View {
        HStack(spacing: 4) {
            Image(systemName: changeIcon)
                .font(.caption2)
                .foregroundColor(changeColor)
            
            Text(formattedChange)
                .font(.caption2.weight(.medium))
                .foregroundColor(changeColor)
        }
        .padding(.horizontal, 8)
        .padding(.vertical, 4)
        .background(
            RoundedRectangle(cornerRadius: 12)
                .fill(changeColor.opacity(0.1))
                .stroke(changeColor.opacity(0.3), lineWidth: 0.5)
        )
        .accessibility(label: Text("Daily life expectancy change: \(formattedChange)"))
        .accessibility(addTraits: .isStaticText)
    }
}

#Preview {
    VStack(spacing: 12) {
        ChangeIndicatorView(dailyChange: 0.5, isPositive: true)
        ChangeIndicatorView(dailyChange: -0.3, isPositive: false)
        ChangeIndicatorView(dailyChange: 0.0, isPositive: false)
    }
    .padding()
}